% ALPHA ENGINE DEFINITION
% Generated 17-Mar-2023 11:09:29

% SUGGESTED CITATION:
% Geely 1.5L Miller GHE from 2020 Aachen Paper - ALPHA Map Package. Version 2023-03. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  'Geely 1.5L Miller GHE from 2020 Aachen Paper Octane Modified for Tier 3 Fuel'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.5; 
engine.num_cylinders =  3; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  13.1; 
engine.inertia_kgm2 =  0.095; 
engine.bore_mm =  82.547; 
engine.stroke_mm =  93.428; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     120.23611956317013	;     141.72031645273225	;     159.43535603550373	;     166.21983920867083	;     197.12692952228917	;     216.72654781081587	;     260.82568885528110	;     419.50721334565088	;     515.37816025799339	;     569.25613057682210	;     597.71893710566326	;     626.18174363450441		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     116.88311700000000	;     127.59740300000000	;     141.55844200000001	;     149.02597399999999	;     167.85714300000001	;     186.03896100000000	;     215.58441600000000	;     215.25973999999999	;     193.31786500000001	;     185.27842200000001	;     158.81007599999998	;     0.0000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	     0.0000000000000000	;     626.18174363450441		]; 
engine.naturally_aspirated_torque_Nm = [	     107.42958658702935	    107.42958658702935		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     36.651914291880921	;     733.03828583761833		]; 
engine.closed_throttle_torque_Nm = [	    -11.963636363636365	;    -11.963636363636365	;    -32.536363636363639		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	;     36.651914291880921	;     73.303828583761842	;     94.247779607693786	;     119.03471230272291	;     149.40751815315477	;     179.61719043450532	;     197.21060822125199	;     219.40450933440354	;     241.28528007186685	;     247.96195341938025	;     262.89034430469326	;     276.08122155294552	;     284.62261651665767	;     310.44676094752549	;     340.48033105533057	;     362.67571112293456	;     374.36187437335548	;     380.52813888013873	;     386.30771942890135	;     391.42341331928770	;     407.04175405884587	;     424.32834434076949	;     445.89967114647391	;     467.76672154849598	;     477.02487544932353	;     498.95594142963409	;     520.59455493034034	;     542.85389790284694	;     571.08424844850731	;     598.63299604150586	;     626.18174363450441		]; 
engine.fuel_map_torque_Nm = [	    -34.163181818181819	;    -12.081590909090909	;     10.000000000000000	;     25.867257996951214	;     41.734515993902427	;     58.645914049370560	;     75.557312104838701	;     83.233201552419345	;     90.909090999999989	;     96.844548000000003	;     102.14327137500001	;     108.05104400000000	;     111.46171657894735	;     119.71913539473684	;     131.84962312499999	;     139.19373566666667	;     145.04060316666667	;     152.16836799999999	;     160.77665408333334	;     167.37238950000000	;     170.66125299999999	;     173.82830600000000	;     177.48259862499998	;     179.67517450000000	;     188.39617173809523	;     196.24129900000000	;     199.04292350000000	;     202.33178699999999	;     204.84918749999997	;     210.50319012500000	;     218.43341346250003	;     226.36363680000002		]; 
engine.fuel_map_gps = [
  0.026643869793361336	 -0.018688694124968881	 -0.062703775870872697	 -0.086720729342756320	  -0.11397256211117844	  -0.14440639474662609	  -0.16962344884902963	  -0.18193548822618522	  -0.19515734649015312	  -0.20512487928992482	  -0.20775164060994322	  -0.21309041674832455	  -0.21701113677754819	  -0.21924746981695778	  -0.22376883849643617	  -0.22271891082616765	  -0.21833320541704265	  -0.21530620255695876	  -0.21361064535404298	  -0.21198175529996949	  -0.21051194708445262	  -0.20572681644270172	  -0.19970776666651072	  -0.19114974349450436	  -0.18147661836021833	  -0.17723188240214793	  -0.16688119741584406	  -0.15632560897182843	  -0.14528379228896660	  -0.13116576795616344	  -0.11739053125155871	  -0.10363996778422378	;
  0.087371696987132569	  0.072258666321669163	  0.058662353392494766	  0.052910403808076115	  0.048487715626929731	  0.048712911494512644	  0.056575767291157777	  0.063973994846658416	  0.075785400375424417	  0.090508042774486250	  0.095416683883172981	   0.10693579121388280	   0.11797111839012278	   0.12546102502575104	   0.15074277267751124	   0.18816141564425201	   0.22032160968762826	   0.23807600144485952	   0.24754867338148470	   0.25646743202279304	   0.26438861975381445	   0.28884421410490435	   0.31646146958190591	   0.35152138397230809	   0.38734670820975448	   0.40249550134248036	   0.43827603010804050	   0.47320890932823034	   0.50868309212129614	   0.55293824424309179	   0.59551747179816494	   0.63784109020915414	;
   0.11547676516312057	   0.14881772643862620	   0.17345249474244764	   0.17823733508465484	   0.19908360049034346	   0.24189857870070372	   0.29445506777013636	   0.32606271513103496	   0.36595854047961457	   0.40464976764433802	   0.41636205721655928	   0.44245873983245215	   0.46560301855393310	   0.48074874278172403	   0.52865913354634730	   0.60242156557821314	   0.66285762449525065	   0.69502694478674032	   0.71199810692261756	   0.72789524179076026	   0.74195544839602068	   0.78474427022048410	   0.83171402396942251	   0.88980691150357427	   0.94841701141632218	   0.97325141944127946	    1.0321871078759177	    1.0906936351050247	    1.1512574402881632	    1.2286161107148283	    1.3047422656862457	    1.3812363216401169	;
  0.081128202743700223	   0.15328475757432711	   0.22733801055834157	   0.27225598908393550	   0.32799191131434607	   0.40134171092078458	   0.47932349483998332	   0.52590463406778731	   0.58540214400654578	   0.64454252160583747	   0.66264904764649335	   0.70323275578463318	   0.73938573569298016	   0.76295368647842177	   0.83553431998547545	   0.92501444726156201	   0.99419191263356621	    1.0311478977276822	    1.0507139511290788	    1.0690784160181701	    1.0853508855317371	    1.1352119645742331	    1.1908204352485363	    1.2608219708123718	    1.3326113555527892	    1.3632806969118563	    1.4367492695262198	    1.5118056991241668	    1.5926684837601466	    1.7018234304437019	    1.8138166729283591	    1.9279736137506016	;
  0.047402356500609484	   0.15978334099380465	   0.27715225777639585	   0.34865852997332014	   0.43323291664824332	   0.53606035688135978	   0.64078165709127899	   0.70351003375079435	   0.78370750381081178	   0.86180108387657484	   0.88542311285344288	   0.93795256243104908	   0.98452273736211560	    1.0148567506234152	    1.1073526045754056	    1.2166058489264222	    1.2988791236280228	    1.3422582312101103	    1.3651180198657458	    1.3865158562332449	    1.4054754478994518	    1.4637436579158611	    1.5299675882689765	    1.6147246108935334	    1.7012063609594619	    1.7379994008474364	    1.8252655093195242	    1.9118907128169191	    2.0104629701257624	    2.1673234855215568	    2.3256035879877439	    2.4816767926579901	;
  0.042007251549934468	   0.18463291832764919	   0.32690378684214022	   0.40764815139637456	   0.50267062555662023	   0.61995502716567019	   0.74382640128787791	   0.81818610146785931	   0.91383937716174746	    1.0108980593388701	    1.0408183246277360	    1.1080263996606441	    1.1675630506837766	    1.2060740447727956	    1.3220221936437424	    1.4553783436597303	    1.5546218073688118	    1.6074221475888919	    1.6353947644195093	    1.6616673791500789	    1.6849666436252468	    1.7566339263327093	    1.8377552474399526	    1.9427228245743386	    2.0548718149456797	    2.1038281224494795	    2.2234808145629725	    2.3492461115523215	    2.4876450061050446	    2.6769660408769997	    2.8538439372282243	    3.0267861194373107	;
  0.060513166743341305	   0.22408833870241282	   0.38687910180931617	   0.47904250509424895	   0.58726339406041794	   0.71984286114021745	   0.86129626428250206	   0.94630243756848464	    1.0560933108566879	    1.1695609917810434	    1.2048675258148203	    1.2845174909791401	    1.3552887169636805	    1.4010078930733210	    1.5385237357669277	    1.6921694988789451	    1.8073274949116322	    1.8696991382180659	    1.9027454285963681	    1.9337664739699092	    1.9612569745970856	    2.0457418972138419	    2.1424009355514357	    2.2692026399319674	    2.4048470168901495	    2.4636743585231708	    2.6062319513748213	    2.7525804776951599	    2.9084080264596475	    3.1130664988771359	    3.3171840379428592	    3.5227652754124512	;
  0.073301465937484295	   0.24618073846688479	   0.41907437421969079	   0.51788169564459419	   0.63472113455624879	   0.77944905988799029	   0.93000150351916500	    1.0206649137472312	    1.1379097807849079	    1.2572557824739661	    1.2940959473135898	    1.3769526386769091	    1.4506234860395235	    1.4984121121971219	    1.6432022157741200	    1.8109754808470380	    1.9371301440681281	    2.0044857408300594	    2.0401167492276016	    2.0735493534057854	    2.1031682159177212	    2.1940587507415752	    2.2977278642032943	    2.4332022247600489	    2.5772143282422428	    2.6393234077648104	    2.7890962337850826	    2.9429269159056468	    3.1073972535154049	    3.3242324682610600	    3.5415567077733594	    3.7610116861894225	;
  0.087846446769285630	   0.27815196415987231	   0.45613712705493986	   0.56016518119730785	   0.68467885943324946	   0.84138695774739314	    1.0025947174340719	    1.0990738194129743	    1.2232239340551749	    1.3485392831064023	    1.3871122835778260	    1.4737628083546837	    1.5508409249099313	    1.6009200113105058	    1.7535193064253072	    1.9345635204507283	    2.0713795215956909	    2.1442766856046824	    2.1828891200645519	    2.2191485719895399	    2.2512985223191970	    2.3501220667429861	    2.4618287910530574	    2.6057256886072824	    2.7570275008403260	    2.8220192569085309	    2.9782715189670670	    3.1399582547696552	    3.3146262572431207	    3.5449356686171591	    3.7751099977270064	    4.0071256580620362	;
   0.10018598933930434	   0.31175580936051689	   0.49138756373670162	   0.59702336847533843	   0.72481495571982746	   0.89019153168898646	    1.0599000743543512	    1.1609945783925126	    1.2905990545933996	    1.4209007419890940	    1.4609846623819507	    1.5510209708637233	    1.6311840472016756	    1.6833230400976518	    1.8427087396746422	    2.0334758385087710	    2.1781612015582299	    2.2553227170273931	    2.2962018939105988	    2.3345917890184338	    2.3686302255859477	    2.4732277202792083	    2.5911171466269209	    2.7421859725572286	    2.9003409407825447	    2.9683268105239957	    3.1319530739101680	    3.3007323219530282	    3.4834940737987901	    3.7237499322497221	    3.9626232549654694	    4.2024225683243444	;
   0.11180180643026427	   0.34506806256709749	   0.52594154273209059	   0.63279262754769661	   0.76330605610586733	   0.93413110810431554	    1.1114041216870283	    1.2167487236661412	    1.3514771260221812	    1.4865102455213635	    1.5280289131995990	    1.6212877346833892	    1.7044340544201730	    1.7585797900147715	    1.9245897724489942	    2.1238300661665206	    2.2752009136036651	    2.3559823323672076	    2.3987831437082505	    2.4389779984005786	    2.4746161147639585	    2.5841137233844389	    2.7074378267863684	    2.8653361704896598	    3.0308403561908310	    3.1021883250833322	    3.2743847473843193	    3.4512215372280792	    3.6403205968894952	    3.8890118131729645	    4.1343327644021235	    4.3793013189555108	;
   0.12524024119351643	   0.38602535027239554	   0.56803746694585222	   0.67601496361038438	   0.80864538042878764	   0.98338660972768988	    1.1689535239430526	    1.2792408372444815	    1.4200513749937138	    1.5607446312975266	    1.6039349710782356	    1.7008942887059482	    1.7875593159071801	    1.8441368188632714	    2.0182084134602545	    2.2265506568255828	    2.3849428784895967	    2.4695450059135218	    2.5143807705907832	    2.5564908431719160	    2.5938299251490000	    2.7085849106190234	    2.8379342126633764	    3.0038354251137047	    3.1783791461747248	    3.2538040033024962	    3.4361713742493021	    3.6230112216915877	    3.8211582963045752	    4.0795358325643996	    4.3298795346031902	    4.5785284471536354	;
   0.13324222715832820	   0.41110993069821256	   0.59375743840608153	   0.70234196505912472	   0.83591311749642350	    1.0119317300426116	    1.2021395415075786	    1.3153667465192207	    1.4597745802443742	    1.6039350489394830	    1.6481458219365603	    1.7473740761610310	    1.8361621727641642	    1.8941953589734886	    2.0729545903163440	    2.2863521097544983	    2.4486954224834996	    2.5354593491098867	    2.5814495004088940	    2.6246475387765851	    2.6629541121793152	    2.7807137693701902	    2.9135463320237713	    3.0841240264574190	    3.2639221384724157	    3.3416837507709296	    3.5298199945146327	    3.7225586332136102	    3.9269221701860304	    4.1913148469297976	    4.4436377147410280	    4.6940491658857466	;
   0.16894925243962003	   0.47623592285606536	   0.66111635638682409	   0.77130180832772577	   0.90658237606930292	    1.0827053296488751	    1.2823813029824456	    1.4026619582771842	    1.5559399858997669	    1.7089617218483741	    1.7559943775776068	    1.8616477786192891	    1.9559649490551498	    2.0174527974319685	    2.2063986943968290	    2.4320837725736841	    2.6040372983032190	    2.6959778691737926	    2.7447445906495171	    2.7905631433132490	    2.8312021391093940	    2.9562294152033637	    3.0975358603438665	    3.2794698537412232	    3.4717031531925313	    3.5548873268118433	    3.7562187333518771	    3.9626182210898708	    4.1813829306228705	    4.4620845953384194	    4.7201333225294446	    4.9755079059492866	;
   0.20529595491879443	   0.57282723192681795	   0.77396126539027066	   0.89327062632696175	    1.0380394581855428	    1.2218554097479546	    1.4177688879584869	    1.5382496023797907	    1.7006829650077919	    1.8650846285728957	    1.9157124933250154	    2.0294785938494684	    2.1307631748426510	    2.1966395462166042	    2.3981985995542585	    2.6430719338569877	    2.8311632418787398	    2.9318107075135287	    2.9851754981953649	    3.0352992855156042	    3.0797442446669105	    3.2163607838518571	    3.3706257052512560	    3.5687504703514668	    3.7765074863055257	    3.8658764454425856	    4.0808366247469952	    4.2987556066740291	    4.5279720519896216	    4.8238623205289972	    5.1131008515122582	    5.4020069538189217	;
   0.21169927158857976	   0.61449512820245245	   0.83844558255187662	   0.97022876486833398	    1.1283535861671785	    1.3237496193587976	    1.5164295204094853	    1.6320386104486706	    1.7888045431038790	    1.9575910918673951	    2.0100512516846161	    2.1285565678248712	    2.2347792904647821	    2.3040073146200557	    2.5161903879959482	    2.7707637467971757	    2.9669478631597288	    3.0727989636174295	    3.1290613284947550	    3.1819690844465396	    3.2289251495686222	    3.3736321324635523	    3.5371415235017643	    3.7453764055550547	    3.9608639087736845	    4.0533192673151266	    4.2755336121073997	    4.5018508946370925	    4.7416478025296929	    5.0548126964838254	    5.3660148600023438	    5.6788878810281531	;
   0.21184501934378075	   0.64256088306810133	   0.88450733068140419	    1.0289693098119659	    1.2006985662899634	    1.4074302397283482	    1.5987909945887955	    1.7117135637423226	    1.8610150495053757	    2.0302396455215619	    2.0836729670670957	    2.2051930108659938	    2.3156734097592393	    2.3882085387047884	    2.6132704493475369	    2.8730132988550738	    3.0741169111270086	    3.1838728521457744	    3.2424540832531550	    3.2976523942793112	    3.3467220024022519	    3.4987486517615842	    3.6711321791163720	    3.8869404040753710	    4.1075363455448537	    4.2023938447595901	    4.4313012626311430	    4.6666239001416656	    4.9177650502395958	    5.2477592540924514	    5.5771255122003787	    5.9088791012646791	;
   0.20517603610566615	   0.67092626719727821	   0.93234927357035458	    1.0927992307733543	    1.2846122344034157	    1.5095723172643811	    1.7091138581496188	    1.8214846020734221	    1.9616407945025436	    2.1197908114399038	    2.1732052688093124	    2.2956074110944487	    2.4099508407268573	    2.4865869736303985	    2.7348875939982458	    2.9976824706709655	    3.2048066558651991	    3.3189639936442012	    3.3800495258027348	    3.4376701414146162	    3.4889373900611456	    3.6482401991911400	    3.8299262099748463	    4.0578665041397510	    4.2859926686945853	    4.3847548854962470	    4.6253135196093922	    4.8758157703774634	    5.1444779714266016	    5.4974734903370726	    5.8487980694278852	    6.2021444783940538	;
   0.18334033630655810	   0.69153661623219920	   0.98006801443144698	    1.1552156685272152	    1.3665863815952144	    1.6217200505381018	    1.8521381587457504	    1.9757602098604532	    2.1192774521375055	    2.2578734161016820	    2.3013960938796481	    2.4103081151999901	    2.5201179475418756	    2.5956131457931204	    2.8469794307204825	    3.1455214224496721	    3.3703702775948505	    3.4905584634309825	    3.5543063529348466	    3.6142087247073471	    3.6673507849076792	    3.8310009743366060	    4.0165643099724075	    4.2561256285974558	    4.5053102310408999	    4.6140863255016722	    4.8807786967713573	    5.1575174880152668	    5.4511395862814966	    5.8314531594934031	    6.2054417796778907	    6.5797629482448636	;
   0.15576674040364763	   0.69544336048542177	    1.0070730924135156	    1.1940493727328876	    1.4192487136462775	    1.6911259687485194	    1.9479191426459415	    2.0875130538979492	    2.2554057423194167	    2.4083545320165523	    2.4598863253297223	    2.5566883348189968	    2.6512850634500222	    2.7200316395220057	    2.9687576233023671	    3.2803341907606911	    3.5169682467676044	    3.6424213729016408	    3.7087188254587300	    3.7709010262931844	    3.8259758342206434	    3.9946061127931731	    4.1839445173627210	    4.4291130437378623	    4.7000505014544025	    4.8198524065539994	    5.1121123498160612	    5.4086064432201946	    5.7180003376067807	    6.1133460757805373	    6.4989817763547846	    6.8841646014872593	;
   0.13958049779591503	   0.69462234056456151	    1.0182951701211385	    1.2112556844474325	    1.4433887804755197	    1.7236897336030903	    1.9918922869781663	    2.1427349011332772	    2.3268217933519306	    2.4824602043326220	    2.5259206518335167	    2.6263733604388908	    2.7248104449941759	    2.7936117117631416	    3.0384241004126769	    3.3548193693391903	    3.5965393306173636	    3.7248369660105762	    3.7926542527733984	    3.8562684615497891	    3.9126163599889638	    4.0851989505785520	    4.2791583312853136	    4.5308755300139643	    4.8123995865008578	    4.9367326770729711	    5.2388628476807462	    5.5430749939490855	    5.8584673766763213	    6.2591826170051865	    6.6492351692631466	    7.0387938560351593	;
   0.12294212453949654	   0.69263749658681573	    1.0281633596513269	    1.2269265265753451	    1.4657539046018009	    1.7541996355808738	    2.0326469569955057	    2.1958310349770120	    2.3927454004560378	    2.5416699139431107	    2.5874235204687217	    2.6938101094384725	    2.7958803342713985	    2.8659604414154671	    3.1087993577783668	    3.4298770440216888	    3.6762329663818991	    3.8073566822144889	    3.8767472781020649	    3.9418760816124561	    3.9995966894499531	    4.1767327000355667	    4.3766172184487582	    4.6371150841315067	    4.9281209295568722	    5.0560124409661169	    5.3660196226874479	    5.6766110952369964	    5.9968105992015923	    6.4016288564631338	    6.7954129574379118	    7.1888124296082188	;
   0.10240444825822773	   0.68879566392468738	    1.0383264488751047	    1.2438399314548294	    1.4904248071374322	    1.7883365620578329	    2.0776603840884604	    2.2561141497547408	    2.4546228876661509	    2.6104472765620979	    2.6579091356145095	    2.7679139602102829	    2.8736888227862911	    2.9462746725243023	    3.1935019686702737	    3.5209520168640509	    3.7725398477224203	    3.9070261196998564	    3.9783609035709606	    4.0454024196606211	    4.1048918720491789	    4.2882862618649487	    4.4968930324335572	    4.7704089431966894	    5.0708947267123623	    5.2019714658748510	    5.5192979613394844	    5.8359912183399736	    6.1603136697194092	    6.5682895564512505	    6.9658655046223448	    7.3633062175428812	;
  0.089493339674450653	   0.68580701988273718	    1.0438980228574639	    1.2534918308305640	    1.5047565564983136	    1.8083950633045318	    2.1040109758449588	    2.2870451631616850	    2.4913819683072451	    2.6515498201182703	    2.6999615787219762	    2.8121125095587578	    2.9199318246253680	    2.9939014226745488	    3.2455351371560042	    3.5775153148885144	    3.8323527130158670	    3.9689309215921784	    4.0414855742674121	    4.1097402482713852	    4.1703616484623884	    4.3578637026012910	    4.5721421279077621	    4.8535374154901314	    5.1595226677108839	    5.2924864516517216	    5.6138784562371091	    5.9338432160405157	    6.2599945837607915	    6.6691382868497469	    7.0688670500796942	    7.4686045152701510	;
  0.030641123537061239	   0.66482661536558452	    1.0587497692519983	    1.2849582021048023	    1.5552171950653102	    1.8823582778129757	    2.2036637729167103	    2.4041456084790651	    2.6291359353512394	    2.8078029324390634	    2.8611221087876797	    2.9837985896208039	    3.1027571920665555	    3.1849423097617815	    3.4672471320200176	    3.8269664950074689	    4.0977174711559536	    4.2448793196429202	    4.3236072274663213	    4.3979175015517598	    4.4640884865561219	    4.6704087580513116	    4.9085278728655419	    5.2191174152410316	    5.5463337729147009	    5.6866170458651855	    6.0218490277344170	    6.3507721323639217	    6.6764321565535854	    7.0812673648100821	    7.4882468846268848	    7.8956885670023542	;
 -0.010545804206553891	   0.62993779083346491	    1.0593506768607923	    1.3014328329094165	    1.5898006464165113	    1.9395681426933691	    2.2851506529729568	    2.5017875276025783	    2.7466625814001393	    2.9469773789052365	    3.0079425402068138	    3.1485971191237958	    3.2832963721631883	    3.3755429566689306	    3.6861911092617916	    4.0792974596258720	    4.3785102281375599	    4.5396490268486129	    4.6253564959224356	    4.7060056900968821	    4.7776395335638782	    4.9991714276304613	    5.2522426304144370	    5.5797928019909522	    5.9202141173845915	    6.0640728319454631	    6.4035689198350267	    6.7338740742913386	    7.0650315436626823	    7.4794634635668551	    7.8870633223992641	    8.2962932591632956	;
 -0.018084543016840145	   0.62454771025509170	    1.0580639839501269	    1.3059690803750374	    1.6009703092489789	    1.9591076471533098	    2.3139933184948211	    2.5371409820136868	    2.7904496563692036	    2.9998731223294297	    3.0639157180022756	    3.2118491855155642	    3.3526104810827415	    3.4484724519126702	    3.7694070417413328	    4.1756722363911329	    4.4842741678713587	    4.6496084776058852	    4.7373713342851413	    4.8198745888293040	    4.8930960867889715	    5.1189222638000551	    5.3758240567558788	    5.7076977616072053	    6.0522207998861903	    6.1968789219932567	    6.5376690932976427	    6.8690848801037117	    7.2033400937541963	    7.6218418612471117	    8.0311140606037572	    8.4415894715838320	;
 -0.027132242665139659	   0.62905542393218139	    1.0560203341904340	    1.3108361153587418	    1.6137011691158292	    1.9817989983109960	    2.3479111424427805	    2.5790369571436029	    2.8427823755886510	    3.0632738918634907	    3.1309198560656668	    3.2872019519943207	    3.4350906800887602	    3.5353877043063862	    3.8689713012426608	    4.2911086605062279	    4.6103701392448571	    4.7802453837084338	    4.8702108503819321	    4.9546945048305435	    5.0296084906351535	    5.2599773640258949	    5.5207478174003768	    5.8569506924073860	    6.2053951094685393	    6.3512818357940102	    6.6942644909363018	    7.0276249521426859	    7.3655051943980583	    7.7887983141583854	    8.2006335698628554	    8.6129414972817155	;
 -0.034183187441140211	   0.63240948953254950	    1.0558838843461886	    1.3142910036914468	    1.6232312905351596	    1.9990615898097848	    2.3740077221432894	    2.6114697829660494	    2.8835137555576824	    3.1125651763785243	    3.1829214705141595	    3.3454174599533659	    3.4987390898444355	    3.6024980213755389	    3.9462254044991569	    4.3807475453350060	    4.7080320391071648	    4.8811075338452268	    4.9726061966248469	    5.0584671780713206	    5.1345604621145240	    5.3681159776922724	    5.6314788180335302	    5.9705477588660010	    6.3213170919908794	    6.4685338762503539	    6.8136885550248154	    7.1489173706116373	    7.4895099632256112	    7.9164103828081265	    8.3305440137572564	    8.7445616844558902	;
 -0.050475096536446287	   0.63955582950607581	    1.0787517391092991	    1.3259326528999897	    1.6438133007924360	    2.0375050158302992	    2.4333543519771283	    2.6859416206852971	    2.9776801795621353	    3.2259809066843577	    3.3022339472477076	    3.4781229508127769	    3.6435212317712478	    3.7551784955336220	    4.1232922827496967	    4.5862444064919536	    4.9313310548674112	    5.1105658590714915	    5.2049061285211193	    5.2933637387776882	    5.3717201232449705	    5.6116959409822291	    5.8804147087989591	    6.2253196964275990	    6.5802020857576631	    6.7295849911537955	    7.0803744823208516	    7.4209942373295954	    7.7675264167094928	    8.2022681044538306	    8.6227151841011391	    9.0419034449440616	;
 -0.074469736276821921	   0.64854323007768588	    1.1102300091932635	    1.3685511219146100	    1.6768672549522297	    2.0912578925786036	    2.5195957301100633	    2.7952980281316715	    3.1162124520795791	    3.3910094703931080	    3.4752584097804711	    3.6692751875897320	    3.8512948923491770	    3.9739812767915068	    4.3771278196764030	    4.8766469093746245	    5.2424614404677987	    5.4316498727236162	    5.5310812926267010	    5.6241968958349053	    5.7065916475572180	    5.9580888549499376	    6.2373531176163040	    6.5882591819235437	    6.9454377914317016	    7.0963487338840778	    7.4526057539373731	    7.8007624129968161	    8.1556852739097128	    8.6014927157765939	    9.0329647353624196	    9.4628691751283842	;
 -0.099290831138767480	   0.65698508244474241	    1.1415816922490882	    1.4111634591264275	    1.7328579937261586	    2.1456023266651552	    2.6081351450408001	    2.9076837981703916	    3.2581422509623632	    3.5591641688556535	    3.6512968074023688	    3.8631616708990197	    4.0614114646310497	    4.1947837973464326	    4.6311391275982583	    5.1628720257912386	    5.5483975983592151	    5.7488196253371351	    5.8541675345200490	    5.9527387631422064	    6.0398655313291121	    6.3045806637306150	    6.5946720527715845	    6.9529195846313616	    7.3132683985793285	    7.4655367311459573	    7.8256712526525680	    8.1798349251677305	    8.5425936288285627	    8.9998167473655641	    9.4432983275575957	    9.8854941901988855	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('LMDV_TIER_3_REG');

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     68.067840827778852	    68.067840827778852		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
